#version 130

in vec3 inPosition;
in vec3 inNormal;
in vec2 inTexCoords;

out vec3 normal;
out vec3 fragPos;
out vec2 texCoords;

uniform mat4 model;
uniform mat4 camera;
uniform mat4 projection;

void main()
{
	texCoords = inTexCoords;
	fragPos = vec3(model * vec4(inPosition, 1.0f));
	normal = mat3(gl_ModelViewMatrixInverseTranspose) * inNormal;
	gl_Position = projection * camera *  model * vec4(inPosition, 1.0f);
}
