#version 330 core

out vec4 color;

in vec3 normal;
in vec3 fragPos;
in vec2 texCoords;

struct Light
{
	vec3 position;
	vec3 ambient;
	vec3 diffuse;
	vec3 specular;
};

uniform Light light;
uniform vec3 cameraPosition;
uniform vec4 diffuseColor;

void main()
{
	vec3 lightDir = normalize(light.position - fragPos);
	float diff = max(dot(normalize(normal), lightDir), 0.0);
	vec3 diffuse = diff * light.diffuse;

	vec3 result = (light.ambient + diffuse) * diffuseColor.rgb;
	color = vec4(result, 1.0);
}
